package com.hero.model;

import java.awt.Toolkit;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class NumericDocument extends PlainDocument {
    private static final long serialVersionUID = 295096305767229582L;

    int max = 99999;

    int min = -99999;

    StringBuffer holder = new StringBuffer();

    public void setMin(int minVal) {
        min = minVal;
    }

    public void setMax(int maxVal) {
        max = maxVal;
    }

    public NumericDocument(int max, int min) {
        super();
        this.max = max;
        this.min = min;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a)
            throws BadLocationException {
        if (str == null) {
            super.insertString(offs, str, a);
            return;
        }
        if (str.length() == 0) {
            super.insertString(offs, str, a);
            return;
        }
        for (int i = 0; i < str.length(); i++) {
            if (!Character.isDigit(str.charAt(i))) {
                if (!(i == 0 && offs == 0)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                } else if (str.charAt(i) != '-' || min >= 0) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        }
        holder = new StringBuffer(getText(0, getLength()));
        holder.insert(offs, str);
        String check = holder.toString();
        try {
            int val = Integer.parseInt(check);
            if (val > max && checkVal(getText(0, getLength()))) {
                // Toolkit.getDefaultToolkit().beep();
                holder = new StringBuffer(getText(0, getLength()));
                return;
            }
            if (val < min && checkVal(getText(0, getLength()))) {
                // Toolkit.getDefaultToolkit().beep();
                holder = new StringBuffer(getText(0, getLength()));
                return;
            }
        } catch (Exception e) {
            if (check.equals("-") && min < 0) {
                // just continue...
            } else {
                // Toolkit.getDefaultToolkit().beep();
                holder = new StringBuffer(getText(0, getLength()));
                return;
            }
        }
        holder = new StringBuffer(getText(0, getLength()));
        holder.insert(offs, str);
        super.insertString(offs, str, a);
    }

    private boolean checkVal(String val) {
        boolean ret = true;
        try {
            int check = Integer.parseInt(val);
            if (check < min) {
                ret = false;
            }
            if (check > max) {
                ret = false;
            }
        } catch (Exception exp) {
            ret = false;
        }
        return ret;
    }
}
